﻿using System;
using System.Collections;
using System.Globalization;
using System.Threading;
using System.Web;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.WebControls;
using Microsoft.SharePoint.Workflow;

namespace AngebotWorkflow.Layouts.AngebotWorkflow
{
   public partial class GetAngebotData : LayoutsPageBase
   {
      private string _ListGuid;
      private string _ListItemId;
      private SPList _TaskList;
      private SPListItem _TaskListItem;

      protected override void OnLoad(EventArgs ea)
      {
         base.OnLoad(ea);

         try
         {
            // Laden von SharePoint Objekten aus URL Parametern
            _ListGuid = Request.Params["List"];
            _ListItemId = Request.Params["ID"];
            _TaskList = SPContext.Current.Web.Lists[new Guid(_ListGuid)];
            _TaskListItem = _TaskList.GetItemById(Convert.ToInt32(_ListItemId));

            if (!Page.IsPostBack)
            {
               // Zuweisung von bereits vorhandenen Werten
               Kundenname.Text = _TaskListItem["Kundenname"] as string;
               Angebotspreis.Text = _TaskListItem["Angebotspreis"] as string;
            }
         }
         catch (Exception ex)
         {
            SPUtility.TransferToErrorPage(string.Format(CultureInfo.CurrentCulture, "Error occured while associating Workflow template. {0}", ex.Message));
         }
      }

      protected void SubmitClick(object sender, EventArgs e)
      {
         try
         {
            // Speicherung von Daten an der Workflow Aufgabe
            var hashTable = new Hashtable();
            hashTable["Kundenname"] = Kundenname.Text;
            hashTable["Angebotspreis"] = Angebotspreis.Text;
            SPWorkflowTask.AlterTask(_TaskListItem, hashTable, true);
            // Schliessen des Dialogs
            Page.Response.Clear();
            Page.Response.Write(string.Format(CultureInfo.InvariantCulture, "<script type=\"text/javascript\"> window.frameElement.commonModalDialogClose(1, '{0}'); </script>", "null"));
            Page.Response.End();
         }
         catch (ThreadAbortException)
         {
            // ein redirect führt zu diesem Fehler
         }
         catch (Exception ex)
         {
            SPUtility.TransferToErrorPage(string.Format(CultureInfo.CurrentCulture, "Error occured while associating Workflow template. {0}", ex.Message));
         }
      }

      protected void CancelClick(object sender, EventArgs e)
      {
         // Weiterleiten auf die Workflow Einstellungen
         SPUtility.Redirect("WrkSetng.aspx", SPRedirectFlags.RelativeToLayoutsPage, HttpContext.Current, Page.ClientQueryString);
      }
   }
}